%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   MoM-based MATLAB program for a charged square plate


clear all; 
close all;
N = 100;  %total number of patches
a = 1;
V0 = 1;
EPS0 = 8.8542*10^(-12);
n = sqrt(N);

%coordinates of centers of patches

[x,y,S] = localCoordinates(n,n,a,a);

%matrix A 

A = matrixA(EPS0,S,x,y);

%matrix B

B = V0*ones(1,N)';  %transpose -- to make it a column matrix

rhos = A\B;  %solving the equation

% making 2D matrix rhos2D from results for rhos in 1D array

for i = 1:n
rhos2D(i,:) = rhos((i-1)*n +1:i*n);
end;

figure(1);
[x2D,y2D] = meshgrid(0:1/(n-1):1);
surf(x2D,y2D,rhos2D*10^12);
colormap('cool');
shading interp;
title(' Surface charge distribution of the plate');
xlabel('x [m]');
ylabel('y [m]');
zlabel('\rho_s [^{pC}/_{m^2}]');
zlim([0,150])


figure(2);

imagesc(rhos2D);
colormap('cool');
axis equal;
shading interp;
title('Surface charge density');
xlabel('x');
ylabel('y');
axis off;

Qtot = totalCharge(S,rhos);

fprintf(['\nTotal charge of the plate is '...
    '%2.3d pC'], Qtot*10^12);